let chartOptions = {
    responsive: true,
    maintainAspectRatio: false,
    datasetFill: false,
    plugins: {
        labels: {
            render: function() {
                return "";
            },
            fontColor: "#000",
        },
    },
};

let userGraphData = {
    labels: [
        languages.jan,
        languages.feb,
        languages.mar,
        languages.apr,
        languages.may,
        languages.june,
        languages.jul,
        languages.aug,
        languages.sep,
        languages.oct,
        languages.nov,
        languages.dec,
    ],
    datasets: [{
        label: languages.user_registration + ' ' + currentYear,
        backgroundColor: "#f39c12",
        borderColor: "#f39c12",
        data: [],
    }, ],
};

for (let i = 1; i <= 12; i++) {
    userGraphData.datasets[0].data[i - 1] = userGraph[i] || 0;
}

let userGraphCanvas = $("#userGraph").get(0).getContext("2d");
let userGraph_ = $.extend(true, {}, userGraphData);
userGraph_.datasets[0] = userGraphData.datasets[0];

new Chart(userGraphCanvas, {
    type: "bar",
    data: userGraph_,
    options: chartOptions,
});

let meetingGraphData = {
    labels: [
        languages.jan,
        languages.feb,
        languages.mar,
        languages.apr,
        languages.may,
        languages.june,
        languages.jul,
        languages.aug,
        languages.sep,
        languages.oct,
        languages.nov,
        languages.dec,
    ],
    datasets: [{
        label: languages.meetings + ' ' + currentYear,
        backgroundColor: "#f39c12",
        borderColor: "#f39c12",
        data: [],
    }, ],
};

for (let i = 1; i <= 12; i++) {
    meetingGraphData.datasets[0].data[i - 1] = meetingGraph[i] || 0;
}

let meetingGraphCanvas = $("#meetingGraph").get(0).getContext("2d");
let meetingGraph_ = $.extend(true, {}, meetingGraphData);
meetingGraph_.datasets[0] = meetingGraphData.datasets[0];

new Chart(meetingGraphCanvas, {
    type: "bar",
    data: meetingGraph_,
    options: chartOptions,
});